using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class Levels : MonoBehaviour 
{
	
	public GameObject tuyauPrefab;
	public bool loadingInProgress = false;
	
	public static Levels instance;
	Items item;
	
	// La liste des prefabls remplie à la maion
	public GameObject[] tabPrefab;
	
	// Le tableau de jeu
	public GameObject[] board;
	public GameObject[] boardInst;
	
	public int nbPaires;
	
	private int xFacile=3;
	private int yFacile=1;
	private int xMoyen=3;
	private int yMoyen=3;
	private int xDiff=4;
	private int yDiff=3;
	private int nbTuyau;
	private int coordX = 0;
	private int coordY = 0;
	
	void Awake()
	{
		instance = this;
	}
	
	public void CreateLevel(string difficult)
	{
		switch(difficult)
		{
		case"facile": {
				nbTuyau=8;
				coordX=xFacile+1;
				coordY=yFacile+1;
				for (int x=0;x<=xFacile;x++)
				{
					for (int y=0;y<=yFacile;y++)
					{
						GameObject tuyau = Instantiate(tuyauPrefab,new Vector3(30*y,30*x,-35),Quaternion.identity)as GameObject;
						tuyau.transform.parent = this.transform;
						nbPaires=4;
					}
				}
				
				SelectItems("facile");
				break;}	
			
		case"moyen":{
				nbTuyau=16;
				coordX=xMoyen+1;
				coordY=yMoyen+1;
				for (int x=0;x<=xMoyen;x++)
				{
					for (int y=0;y<=yMoyen;y++)
					{
						GameObject tuyau = Instantiate(tuyauPrefab,new Vector3(30*y,30*x,-35),Quaternion.identity)as GameObject;
						tuyau.transform.parent = this.transform;
						nbPaires=8;
					}
				}
				
				SelectItems("moyen");
				break;}	
			
		case"difficile":{
				nbTuyau=20;
				coordX=xDiff+1;
				coordY=yDiff+1;
				for (int x=0;x<=xDiff;x++)
				{
					for (int y=0;y<=yDiff;y++)
					{
						GameObject tuyau = Instantiate(tuyauPrefab,new Vector3(30*y,30*x,-35),Quaternion.identity)as GameObject;
						tuyau.transform.parent = this.transform;
						nbPaires=10;
					}
				}
				
				SelectItems("difficile");
				break;}	
		}
	}
	
	
	
	//Selectionne les memes items 2 à 2 et les rentre à la suite dans un tableau
	public void SelectItems(string difficult)
	{
		
		
		board = new GameObject[nbTuyau];
		boardInst = new GameObject[nbTuyau];
		
		
		switch (difficult) {
		case "facile":{
			for (int i=0;i<4;i++)
			{
				int pos=i*2;
				board[pos]=tabPrefab[i];
				pos++;
				board[pos]=tabPrefab[i];
			}
			break;}
			
		case "moyen":{
			for (int i=0;i<8;i++)
			{
				int pos=i*2;
				board[pos]=tabPrefab[i];	
				pos++;
				board[pos]=tabPrefab[i];						
			}
			//board[14]=tabPrefab [11]; Place les items spéciaux
			break;}
			
		case "difficile":{
			for (int i=0;i<10;i++)
			{
				int pos=i*2;
				board[pos]=tabPrefab[i];			
				pos++;
				board[pos]=tabPrefab[i];
				
			}
			/*board[22]=tabPrefab[11];
			board[23]=tabPrefab[12];
			board[24]=tabPrefab[13];*/
			break;}
			
		}
		
		
		Randomize (difficult);
		
		
	}
	//Randomize le tableau board
	public void Randomize(string difficult)
	{
		GameObject tempo;
		int nbRandom;
		for (int j=0; j<coordY; j++) 
		{
			for (int i=0; i<coordX; i++) 
			{
				//i+(coordX*j) => case courante de board
				nbRandom = Random.Range (i+(coordX*j), board.Length);
				tempo = board [nbRandom];
				board [nbRandom] = board [i+(coordX*j)];
				board [i+(coordX*j)] = tempo;
				
				GameObject itemInst = Instantiate (board [i+(coordX*j)], new Vector3 (30 * j, 30*i,-34.0f), Quaternion.identity)as GameObject;
				boardInst[i+(j*coordX)]=itemInst;
				itemInst.transform.parent = this.transform;
			}
		}
		
	}
	
	public void Clear()
	{
		for (int childIndex=0; childIndex<transform.childCount; childIndex++) {
			Transform child=transform.GetChild (childIndex);
			Destroy (child.gameObject);
		}
		
	}
}

